unit Dispatch03;
// ================================================================
(*

                

        Request, 
       DataBuffer   
      Reques.

   -----------------------------------------------------
    3.7. ()  , , , 2017..2020 .
               () Source code  ..
     12.01.2020
*)
// ================================================================

interface

uses //  
     SysUtils,
     //  
     CommonDEF03, CommonDAT03, CommonSRV03;

// ================================================================
//      
// ================================================================
type TRequest = record
   //  
   RqCmd   : string;      //    
   //  
   Buffer  : pointer;     //    nil
   BufSize : integer;     //    
end;

// ================================================================
//    
// ================================================================
//   
function ServiceDispatch(var Request : TRequest) : boolean;

// ==========================================================================
// --------------------------------------------------------------------------
implementation
// --------------------------------------------------------------------------
// ==========================================================================

// ==========================================================================
//      
// ==========================================================================
// --------------------------------------------------------------------------
//          
procedure  GetSensorsData(RqAppIndx : integer);
var Indx   : integer;
    Value  : extended;
begin
   if (RqAppIndx < Low(AllSensorArr)) or
      (RqAppIndx > High(AllSensorArr))
     then Exit;
   // ----------------------------------
   with AllSensorArr[RqAppIndx]
   do begin
      //   
      for Indx := Low(AppSensorArr) to High(AppSensorArr)
      do begin
          //  
          Value := AppSensorArr[Indx].Value;
          //   ,   
          if AppSensorArr[Indx].RqNoise
          then Value := Value - AppSensorArr[Indx].Noise / 2
                 + random(Round(AppSensorArr[Indx].Noise));
          //      
          DataBuffer.BufArr[Indx].Indx  := Indx;
          DataBuffer.BufArr[Indx].Value := Value;
      end;
   end;
end;
// ----------------------------------------------------------------
//           
procedure  GetModelData(RqAppIndx, RqModelIndx : integer);
begin
(*
  .
      .

   AllSensorArr    ,  
        ,  
    ,  ( )   
     .
   ServiceDispatch       ,
             .
   ( )   (   ) 
      ServiceDispatch  
  .        
           .
           UnEnabled.
*)
end;

// ================================================================
//       
// ================================================================
// ----------------------------------------------------------------
//   
function ServiceDispatch(var Request : TRequest) : boolean;
var wAppIndx   : integer;
    wItemCount : integer;
    wBufSize   : integer;
begin
   // -------------------
   //  
   // -------------------
   Result := False;
   Request.Buffer  := nil;
   Request.BufSize := 0;
   FillChar(DataBuffer, SizeOF(DataBuffer), #0);
   try
     wAppIndx := StrToInt(Trim(Request.RqCmd));
     if (wAppIndx >= Low(AllSensorArr)) and (wAppIndx <= High(AllSensorArr))
     then begin
        wItemCount := Length(AllSensorArr[wAppIndx].AppSensorArr);
        if wItemCount > 0
        then begin
           // -------------------
           //   
           //      
           GetSensorsData(wAppIndx);
           // -------------------
           //     
           Request.Buffer  := Addr(DataBuffer);
           wBufSize := wItemCount * SizeOF(TBufferItem);
           Request.BufSize := wBufSize;
           Result := True;
        end;
     end;
   except end;
end;

// --------------------------------------------------------------------------
// ================================================================
//  
// ==========================================================================
end.
